﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UnityEngine;
using UnityEngine.SceneManagement;

public class SceneLoadTask : LoadTask
{
    private string _SceneName;  //The name of the scene to load
    private string _LoadingText;    //The text to display while loading

    public SceneLoadTask(string sceneName, string loadingText) : base(false)
    {
        _SceneName = sceneName;
        _LoadingText = loadingText;
    }

    public override IEnumerator RunLoadTask()
    {
        //Set up the UI, load and await asynchronously until done
        LoadingScript.HideProgressBar();
        LoadingScript.LoadingText.text = _LoadingText;
        AsyncOperation async;
        async = SceneManager.LoadSceneAsync(_SceneName);

        //Wait until the load is done
        while (!async.isDone)
        {
            yield return null;
        }

        yield return async;
    }
}
